
use master

create database [CCDES]
go

use CCDES
go

create table
Cliente
	(
	cd_cliente		integer 	not null	Identity(1,1),
	nm_cliente		varchar(255)	not null,
	cnpj			varchar(20)	not null,
	endereco		varchar(255)	not null,
	endereco_complemento	varchar(255)	null,
	bairro			varchar(150)	not null,
	cep			varchar(9)	not null,
	cidade			varchar(150)	not null,
	uf			varchar(2)	not null,
	primary key(cd_cliente)
	)
go

create table
Funcionario
	(
	cd_funcionario		integer 	not null	Identity(1,1),
	nm_funcionario		varchar(255)	not null,
	login_funcionario	varchar (20)	not null,
	senha_funcionario	varchar (10)	not null,
	primary key(cd_funcionario)
	)
go
	
create table
Papel
	(
	cd_papel		integer 	not null	Identity(1,1),
	nm_papel		varchar (100)	not null,
	primary key(cd_papel)
	)
go

create table
PapelFuncionario
	(
	cd_papelfuncionario	integer 	not null	Identity(1,1),
	cd_funcionario		integer 	not null,
	cd_papel		integer 	not null,
	primary key(cd_papelfuncionario)
	)
go

create table
Projeto
	(
	cd_projeto		integer 	not null	Identity(1,1),
	nm_projeto		varchar(255) 	not null,
	vl_horas		real	 	not null,
	vl_prazo		real	 	not null,
	cd_cliente		integer 	not null,
	primary key(cd_projeto)
	)
go

create table
Fases
	(
	cd_fase			integer 	not null	Identity(1,1),
	nm_fase			varchar(100) 	not null,
	cd_projeto		integer 	not null,
	vl_horas		real	 	not null,
	vl_prazo		real	 	not null,
	primary key(cd_fase)
	)
go

create table
Entregavel
	(
	cd_entregavel		integer 	not null	Identity(1,1),
	nm_entregavel		varchar(100)	not null,
	cd_fase 		integer		not null,
	vl_horas		real	 	not null,
	vl_prazo		real	 	not null,
	primary key(cd_entregavel)
	)
go

create table
PapelProjeto
	(
	cd_papelprojeto		integer 	not null	Identity(1,1),
	cd_projeto		integer 	not null,
	cd_papel		integer 	not null,
	vl_qtde			integer 	not null,
	primary key(cd_papelprojeto)
	)
go

create table
PapelFuncionarioProjeto
	(
	cd_papelfuncionarioprojeto	integer	not null	Identity(1,1),
	cd_papelfuncionario		integer not null,
	cd_papelprojeto			integer not null,
	vl_horas			real	not null,
	primary key (cd_papelfuncionarioprojeto)
	)
go

create table
Atividade
	(
	cd_atividade		integer 	not null 	Identity(1,1),
	nm_atividade		varchar(500)	not null,
	cd_entregavel		integer 	not null,
	cd_papelfuncionarioprojeto	integer	not null,
	ds_atividade		text		not null,
	dt_inicio		datetime	not null,
	dt_termino		datetime	not null,
	vl_duracao		real		not null,
	primary key (cd_atividade)
	)
go

